-- ============================================
-- TABLA PARA TARJETAS USADAS
-- Sistema Profesional con MySQL
-- ============================================

CREATE TABLE IF NOT EXISTS `used_cards` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `card_id` VARCHAR(255) NOT NULL,
    `card_number` VARCHAR(20) DEFAULT NULL,
    `card_format` TEXT DEFAULT NULL,
    `titular` VARCHAR(255) DEFAULT NULL,
    `banco` VARCHAR(255) DEFAULT NULL,
    `timestamp` INT(11) NOT NULL,
    `date_used` DATETIME NOT NULL,
    `ip_address` VARCHAR(45) DEFAULT NULL,
    `user_agent` TEXT DEFAULT NULL,
    `additional_info` JSON DEFAULT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY `unique_card_id` (`card_id`),
    INDEX `idx_card_number` (`card_number`),
    INDEX `idx_banco` (`banco`),
    INDEX `idx_date_used` (`date_used`),
    INDEX `idx_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- NOTAS:
-- - card_id: Hash único MD5 de la tarjeta
-- - card_number: Número de tarjeta para búsquedas rápidas
-- - card_format: Formato completo de la tarjeta
-- - timestamp: Unix timestamp para comparaciones rápidas
-- - date_used: Fecha legible para reportes
-- - additional_info: JSON con información extra (email, teléfono, etc.)
-- - UNIQUE KEY asegura que no se dupliquen tarjetas
-- ============================================

-- Opcional: Limpiar registros antiguos (más de 90 días)
-- Puedes crear un evento programado para esto:
-- CREATE EVENT IF NOT EXISTS cleanup_old_used_cards
-- ON SCHEDULE EVERY 1 DAY
-- DO DELETE FROM used_cards WHERE date_used < DATE_SUB(NOW(), INTERVAL 90 DAY);

