<?php
/**
 * Sistema de Autenticación Simple
 * Login estático sin base de datos
 * Sesiones persistentes
 */

// Iniciar sesión
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 🔐 CONFIGURACIÓN DE USUARIOS
// Agrega o modifica usuarios aquí
$usuarios = [
    'Juanelo' => [
        'password' => 'eljuan123Jm$',  // Cambia esta contraseña
        'nombre'   => 'JuaneloAdmin',
        'nivel'    => 'admin'
    ],
    'usuario1' => [
        'password' => 'pass123',  // Cambia esta contraseña
        'nombre'   => 'Usuario 1',
        'nivel'    => 'user'
    ],
    'usuario2' => [
        'password' => 'pass456',  // Cambia esta contraseña
        'nombre'   => 'Usuario 2',
        'nivel'    => 'user'
    ]
    // Agrega más usuarios aquí siguiendo el mismo formato
];

/**
 * Verificar si el usuario está autenticado
 */
function estaAutenticado()
{
    return isset($_SESSION['usuario_autenticado']) && $_SESSION['usuario_autenticado'] === true;
}

/**
 * Obtener información del usuario actual
 */
function obtenerUsuarioActual()
{
    if (estaAutenticado()) {
        return [
            'username' => $_SESSION['username'] ?? 'Desconocido',
            'nombre'   => $_SESSION['nombre_completo'] ?? 'Usuario',
            'nivel'    => $_SESSION['nivel'] ?? 'user'
        ];
    }
    return null;
}

/**
 * Procesar login
 */
function procesarLogin($username, $password)
{
    global $usuarios;

    // Verificar que el usuario exista
    if (!isset($usuarios[$username])) {
        return [
            'success' => false,
            'error'   => 'Usuario no encontrado'
        ];
    }

    // Verificar contraseña
    if ($usuarios[$username]['password'] !== $password) {
        return [
            'success' => false,
            'error'   => 'Contraseña incorrecta'
        ];
    }

    // Login exitoso - crear sesión
    $_SESSION['usuario_autenticado'] = true;
    $_SESSION['username'] = $username;
    $_SESSION['nombre_completo'] = $usuarios[$username]['nombre'];
    $_SESSION['nivel'] = $usuarios[$username]['nivel'];
    $_SESSION['login_time'] = time();
    $_SESSION['ip_address'] = $_SERVER['REMOTE_ADDR'] ?? 'unknown';

    return [
        'success' => true,
        'message' => 'Login exitoso',
        'usuario' => $usuarios[$username]['nombre']
    ];
}

/**
 * Cerrar sesión
 */
function cerrarSesion()
{
    session_unset();
    session_destroy();
}

/**
 * Verificar y redirigir si no está autenticado
 */
function requerirAutenticacion()
{
    if (!estaAutenticado()) {
        header('Location: login.php');
        exit;
    }
}

/**
 * Procesar petición de login/logout
 */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'login') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';

            $resultado = procesarLogin($username, $password);

            if ($resultado['success']) {
                // Redirigir a la página principal
                header('Location: web_interface_organized.php');
                exit;
            } else {
                $_SESSION['login_error'] = $resultado['error'];
                header('Location: login.php');
                exit;
            }
        } elseif ($_POST['action'] === 'logout') {
            cerrarSesion();
            header('Location: login.php');
            exit;
        }
    }
}
?>

